/**
 * OWASP AppSensor
 * 
 * This file is part of the Open Web Application Security Project (OWASP)
 * AppSensor project. For details, please see
 * <a href="http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project">
 * 	http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project</a>.
 *
 * Copyright (c) 2010 - The OWASP Foundation
 * 
 * AppSensor is published by OWASP under the BSD license. You should read and accept the
 * LICENSE before you use, modify, and/or redistribute this software.
 * 
 * @author Michael Coates <a href="http://www.aspectsecurity.com">Aspect Security</a>
 * @author John Melton <a href="http://www.jtmelton.com/">jtmelton</a>
 * @created 2010
 */
using System;
using System.Globalization;
namespace org.owasp.appsensor
{


    /**
     * This class is simply a helper class with various date 
     * manipulation methods.
     * 
     * @author Michael Coates (michael.coates .at. owasp.org) 
     *         <a href="http://www.aspectsecurity.com">Aspect Security</a>
     * @author John Melton (jtmelton .at. gmail.com)
     *         <a href="http://www.jtmelton.com/">jtmelton</a>
     * @since February 24, 2010
     */
    public class DateUtils
    {

        /**
         * Retrieves the current time in a long format
         * @return the current time in a long format
         */
        public static TimeSpan CurrentTime
        {
            get
            {
                return DateTime.Now.TimeOfDay;
            }
        }

        /**
         * Retrieves the time (as of the specified number of seconds ago) as a long.  
         * First the current time is retrieved, 
         * then the number of seconds passed in are subtracted from the current time.
         * Finally the time is returned.
         * @param numberOfSecondsAgoLong number of seconds to subtract from current time
         * @return the time (as of the specified number of seconds ago) as a long.  
         */
        public static TimeSpan getTimeNumberOfSecondsAgo(long numberOfSecondsAgoLong)
        {
            //take away number of seconds
            return DateTime.Now.AddSeconds(-numberOfSecondsAgoLong).TimeOfDay;
        }

        /**
         * Retrieves the time (as of the specified number of seconds ago) as a long.  
         * First the current time is retrieved, 
         * then the number of seconds passed in are added to the current time.
         * Finally the time is returned.
         * @param numberOfSecondsFromNowLong number of seconds to add to current time
         * @return the time (as of the specified number of seconds from now) as a long.  
         */
        public static TimeSpan getTimeNumberOfSecondsFromNow(long numberOfSecondsFromNowLong)
        {
            return DateTime.Now.AddSeconds(-numberOfSecondsFromNowLong).TimeOfDay;
        }

    }
}